using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Linq;
using Crestron;
using Crestron.Logos.SplusLibrary;
using Crestron.Logos.SplusObjects;
using Crestron.SimplSharp;

namespace UserModule_RECEIVER_CN_AV_V1
{
    public class UserModuleClass_RECEIVER_CN_AV_V1 : SplusObject
    {
        static CCriticalSection g_criticalSection = new CCriticalSection();
        
        
        
        
        
        Crestron.Logos.SplusObjects.DigitalInput GET_RX_STATUS;
        Crestron.Logos.SplusObjects.DigitalInput RX_REBOOT;
        Crestron.Logos.SplusObjects.DigitalInput RX_LED_ON;
        Crestron.Logos.SplusObjects.DigitalInput RX_LED_OFF;
        Crestron.Logos.SplusObjects.DigitalInput RX_OUTPUT_ON;
        Crestron.Logos.SplusObjects.DigitalInput RX_OUTPUT_OFF;
        Crestron.Logos.SplusObjects.DigitalInput RX_OUTPUT_MUTE_ON;
        Crestron.Logos.SplusObjects.DigitalInput RX_OUTPUT_MUTE_OFF;
        Crestron.Logos.SplusObjects.DigitalInput RX_IR_VOL_5V;
        Crestron.Logos.SplusObjects.DigitalInput RX_IR_VOL_12V;
        Crestron.Logos.SplusObjects.DigitalInput RX_IO_VOL_5V;
        Crestron.Logos.SplusObjects.DigitalInput RX_IO_VOL_12V;
        Crestron.Logos.SplusObjects.DigitalInput RX_IO1_DIR_IN;
        Crestron.Logos.SplusObjects.DigitalInput RX_IO1_DIR_OUT;
        Crestron.Logos.SplusObjects.DigitalInput RX_IO2_DIR_IN;
        Crestron.Logos.SplusObjects.DigitalInput RX_IO2_DIR_OUT;
        Crestron.Logos.SplusObjects.DigitalInput RX_IO1_OUT_LOW;
        Crestron.Logos.SplusObjects.DigitalInput RX_IO1_OUT_HIGH;
        Crestron.Logos.SplusObjects.DigitalInput RX_IO2_OUT_LOW;
        Crestron.Logos.SplusObjects.DigitalInput RX_IO2_OUT_HIGH;
        Crestron.Logos.SplusObjects.DigitalInput RX_RELAY1_OPEN;
        Crestron.Logos.SplusObjects.DigitalInput RX_RELAY1_CLOSE;
        Crestron.Logos.SplusObjects.DigitalInput RX_RELAY2_OPEN;
        Crestron.Logos.SplusObjects.DigitalInput RX_RELAY2_CLOSE;
        Crestron.Logos.SplusObjects.DigitalInput RX_FLIP_OFF;
        Crestron.Logos.SplusObjects.DigitalInput RX_FLIP_HOR;
        Crestron.Logos.SplusObjects.DigitalInput RX_FLIP_VER;
        Crestron.Logos.SplusObjects.DigitalInput RX_ARP_ARC;
        Crestron.Logos.SplusObjects.DigitalInput RX_ARP_SPDIF;
        Crestron.Logos.SplusObjects.DigitalInput RX_EARC_ON;
        Crestron.Logos.SplusObjects.DigitalInput RX_EARC_OFF;
        Crestron.Logos.SplusObjects.DigitalInput RX_SAC_OFF;
        Crestron.Logos.SplusObjects.DigitalInput RX_SAC_CEC;
        Crestron.Logos.SplusObjects.DigitalInput RX_SAC_ARC;
        Crestron.Logos.SplusObjects.DigitalInput RX_USB_ON;
        Crestron.Logos.SplusObjects.DigitalInput RX_USB_OFF;
        Crestron.Logos.SplusObjects.DigitalInput RX_OSD_MUTE_ON;
        Crestron.Logos.SplusObjects.DigitalInput RX_OSD_MUTE_OFF;
        Crestron.Logos.SplusObjects.DigitalInput RX_CYCLE_PLAY_ON;
        Crestron.Logos.SplusObjects.DigitalInput RX_CYCLE_PLAY_OFF;
        Crestron.Logos.SplusObjects.StringInput RX_NAME;
        Crestron.Logos.SplusObjects.BufferInput FROM_DEVICE;
        Crestron.Logos.SplusObjects.AnalogInput RX_SWITCH_TX;
        Crestron.Logos.SplusObjects.AnalogInput RX_SWITCH_MODE;
        Crestron.Logos.SplusObjects.AnalogInput RX_OUTPUT_RESOLUTION;
        Crestron.Logos.SplusObjects.AnalogInput RX_OUTPUT_ROTATE;
        Crestron.Logos.SplusObjects.AnalogInput RX_OSD_CUSTOM;
        Crestron.Logos.SplusObjects.AnalogInput RX_CYCLE_PLAY_INTERVAL;
        Crestron.Logos.SplusObjects.AnalogInput RX_CYCLE_PLAY_SRC;
        Crestron.Logos.SplusObjects.AnalogInput RX_DELETE_PRESET;
        InOutArray<Crestron.Logos.SplusObjects.AnalogInput> RX_ADD_PRESET;
        Crestron.Logos.SplusObjects.StringOutput TO_DEVICE;
        UShortParameter DEBUGMODE;
        UShortParameter RX_ID;
        ushort GSWITCHMODE = 0;
        object GET_RX_STATUS_OnPush_0 ( Object __EventInfo__ )
        
            { 
            Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
            try
            {
                SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
                
                __context__.SourceCodeLine = 131;
                TO_DEVICE  .UpdateValue ( "R RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " STATUS" + "\u000D\u000A"  ) ; 
                
                
            }
            catch(Exception e) { ObjectCatchHandler(e); }
            finally { ObjectFinallyHandler( __SignalEventArg__ ); }
            return this;
            
        }
        
    object RX_REBOOT_OnPush_1 ( Object __EventInfo__ )
    
        { 
        Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
        try
        {
            SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
            
            __context__.SourceCodeLine = 135;
            TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " REBOOT" + "\u000D\u000A"  ) ; 
            
            
        }
        catch(Exception e) { ObjectCatchHandler(e); }
        finally { ObjectFinallyHandler( __SignalEventArg__ ); }
        return this;
        
    }
    
object RX_LED_ON_OnPush_2 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 140;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " LED ON" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_LED_OFF_OnPush_3 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 145;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " LED OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_OUTPUT_ON_OnPush_4 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 151;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " OUTPUT ON" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_OUTPUT_OFF_OnPush_5 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 156;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " OUTPUT OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_OUTPUT_MUTE_ON_OnPush_6 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 161;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " OUTPUT MUTE ON" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_OUTPUT_MUTE_OFF_OnPush_7 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 166;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " OUTPUT MUTE OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IR_VOL_5V_OnPush_8 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 172;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IR VOL 5V" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IR_VOL_12V_OnPush_9 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 177;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IR VOL 12V" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IO_VOL_5V_OnPush_10 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 182;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IO VOL 5V" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IO_VOL_12V_OnPush_11 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 187;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IO VOL 12V" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IO1_DIR_IN_OnPush_12 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 192;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IO 1 DIR IN" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IO1_DIR_OUT_OnPush_13 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 197;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IO 1 DIR OUT" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IO2_DIR_IN_OnPush_14 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 202;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IO 2 DIR IN" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IO2_DIR_OUT_OnPush_15 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 207;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IO 2 DIR OUT" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IO1_OUT_LOW_OnPush_16 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 212;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IO 1 OUT 0" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IO1_OUT_HIGH_OnPush_17 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 217;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IO 1 OUT 1" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IO2_OUT_LOW_OnPush_18 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 222;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IO 2 OUT 0" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_IO2_OUT_HIGH_OnPush_19 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 226;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " IO 2 OUT 1" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_RELAY1_OPEN_OnPush_20 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 231;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " RELAY 1 OPEN" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_RELAY1_CLOSE_OnPush_21 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 236;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " RELAY 1 CLOSE" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_RELAY2_OPEN_OnPush_22 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 241;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " RELAY 2 OPEN" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_RELAY2_CLOSE_OnPush_23 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 246;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " RELAY 2 CLOSE" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_FLIP_OFF_OnPush_24 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 251;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " OUTPUT FLIP OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_FLIP_HOR_OnPush_25 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 256;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " OUTPUT FLIP HOR" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_FLIP_VER_OnPush_26 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 261;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " OUTPUT FLIP VER" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_ARP_ARC_OnPush_27 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 277;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " ARP ARC" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_ARP_SPDIF_OnPush_28 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 282;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " ARP SPDIF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_EARC_ON_OnPush_29 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 287;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " EARC DOWNGRADE ON" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_EARC_OFF_OnPush_30 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 292;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " EARC DOWNGRADE OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_SAC_OFF_OnPush_31 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 297;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " SAC OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_SAC_CEC_OnPush_32 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 302;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " SAC CEC" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_SAC_ARC_OnPush_33 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 307;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " SAC ARC" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_USB_ON_OnPush_34 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 312;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " USB DATA ON" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_USB_OFF_OnPush_35 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 317;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " USB DATA OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_OSD_MUTE_ON_OnPush_36 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 322;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " CUSTOM OSD MUTE ON" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_OSD_MUTE_OFF_OnPush_37 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 327;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " CUSTOM OSD MUTE OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_CYCLE_PLAY_ON_OnPush_38 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 331;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " CYCLE PLAY ON" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_CYCLE_PLAY_OFF_OnPush_39 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 336;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " CYCLE PLAY OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_OSD_CUSTOM_OnChange_40 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 340;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( RX_OSD_CUSTOM  .UshortValue > 0 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( RX_OSD_CUSTOM  .UshortValue < 8 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 342;
            TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " CUSTOM OSD " + Functions.ItoA (  (int) ( RX_OSD_CUSTOM  .UshortValue ) ) + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_CYCLE_PLAY_INTERVAL_OnChange_41 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 348;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( RX_CYCLE_PLAY_INTERVAL  .UshortValue > 2 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( RX_CYCLE_PLAY_INTERVAL  .UshortValue < 999 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 350;
            TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " CYCLE PLAY INTERVAL " + Functions.ItoA (  (int) ( RX_CYCLE_PLAY_INTERVAL  .UshortValue ) ) + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_CYCLE_PLAY_SRC_OnChange_42 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 355;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " CYCLE PLAY SOURCE " + Functions.ItoA (  (int) ( RX_CYCLE_PLAY_SRC  .UshortValue ) ) + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_NAME_OnChange_43 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 361;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( Functions.Length( RX_NAME ) > 0 ))  ) ) 
            { 
            __context__.SourceCodeLine = 363;
            TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " NAME " + RX_NAME + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_SWITCH_TX_OnChange_44 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        CrestronString PARAM;
        PARAM  = new CrestronString( Crestron.Logos.SplusObjects.CrestronStringEncoding.eEncodingASCII, 10, this );
        
        
        __context__.SourceCodeLine = 370;
        if ( Functions.TestForTrue  ( ( RX_SWITCH_TX  .UshortValue)  ) ) 
            { 
            __context__.SourceCodeLine = 372;
            if ( Functions.TestForTrue  ( ( Functions.BoolToInt (GSWITCHMODE == 0))  ) ) 
                { 
                __context__.SourceCodeLine = 374;
                PARAM  .UpdateValue ( " ALL"  ) ; 
                } 
            
            else 
                {
                __context__.SourceCodeLine = 376;
                if ( Functions.TestForTrue  ( ( Functions.BoolToInt (GSWITCHMODE == 1))  ) ) 
                    { 
                    __context__.SourceCodeLine = 378;
                    PARAM  .UpdateValue ( " VIDEO"  ) ; 
                    } 
                
                else 
                    {
                    __context__.SourceCodeLine = 380;
                    if ( Functions.TestForTrue  ( ( Functions.BoolToInt (GSWITCHMODE == 2))  ) ) 
                        { 
                        __context__.SourceCodeLine = 382;
                        PARAM  .UpdateValue ( " AUDIO"  ) ; 
                        } 
                    
                    else 
                        {
                        __context__.SourceCodeLine = 384;
                        if ( Functions.TestForTrue  ( ( Functions.BoolToInt (GSWITCHMODE == 3))  ) ) 
                            { 
                            __context__.SourceCodeLine = 386;
                            PARAM  .UpdateValue ( " IR"  ) ; 
                            } 
                        
                        else 
                            {
                            __context__.SourceCodeLine = 388;
                            if ( Functions.TestForTrue  ( ( Functions.BoolToInt (GSWITCHMODE == 4))  ) ) 
                                { 
                                __context__.SourceCodeLine = 390;
                                PARAM  .UpdateValue ( " RS232"  ) ; 
                                } 
                            
                            else 
                                {
                                __context__.SourceCodeLine = 392;
                                if ( Functions.TestForTrue  ( ( Functions.BoolToInt (GSWITCHMODE == 5))  ) ) 
                                    { 
                                    __context__.SourceCodeLine = 394;
                                    PARAM  .UpdateValue ( " USB"  ) ; 
                                    } 
                                
                                else 
                                    {
                                    __context__.SourceCodeLine = 396;
                                    if ( Functions.TestForTrue  ( ( Functions.BoolToInt (GSWITCHMODE == 6))  ) ) 
                                        { 
                                        __context__.SourceCodeLine = 398;
                                        PARAM  .UpdateValue ( " CEC"  ) ; 
                                        } 
                                    
                                    }
                                
                                }
                            
                            }
                        
                        }
                    
                    }
                
                }
            
            } 
        
        __context__.SourceCodeLine = 402;
        TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " SWITCH " + Functions.ItoA (  (int) ( RX_SWITCH_TX  .UshortValue ) ) + PARAM + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_SWITCH_MODE_OnChange_45 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 407;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( RX_SWITCH_MODE  .UshortValue >= 0 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( RX_SWITCH_MODE  .UshortValue <= 6 ) )) ))  ) ) 
            {
            __context__.SourceCodeLine = 407;
            GSWITCHMODE = (ushort) ( RX_SWITCH_MODE  .UshortValue ) ; 
            }
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_OUTPUT_RESOLUTION_OnChange_46 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 412;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( RX_OUTPUT_RESOLUTION  .UshortValue >= 0 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( RX_OUTPUT_RESOLUTION  .UshortValue < 14 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 414;
            TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " OUTPUT RESOLUTION " + Functions.ItoA (  (int) ( RX_OUTPUT_RESOLUTION  .UshortValue ) ) + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_OUTPUT_ROTATE_OnChange_47 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 419;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( RX_OUTPUT_ROTATE  .UshortValue >= 0 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( RX_OUTPUT_ROTATE  .UshortValue < 4 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 421;
            TO_DEVICE  .UpdateValue ( "S RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " OUTPUT ROTATE " + Functions.ItoA (  (int) ( RX_OUTPUT_ROTATE  .UshortValue ) ) + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_ADD_PRESET_OnChange_48 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 428;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( RX_ADD_PRESET[ Functions.GetLastModifiedArrayIndex( __SignalEventArg__ ) ] .UshortValue > 0 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( RX_ADD_PRESET[ Functions.GetLastModifiedArrayIndex( __SignalEventArg__ ) ] .UshortValue < 763 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 430;
            TO_DEVICE  .UpdateValue ( "ADD PRESET " + Functions.ItoA (  (int) ( Functions.GetLastModifiedArrayIndex( __SignalEventArg__ ) ) ) + " RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + " SOURCE " + Functions.ItoA (  (int) ( RX_ADD_PRESET[ Functions.GetLastModifiedArrayIndex( __SignalEventArg__ ) ] .UshortValue ) ) + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object RX_DELETE_PRESET_OnChange_49 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 436;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( RX_DELETE_PRESET  .UshortValue > 0 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( RX_DELETE_PRESET  .UshortValue < 11 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 438;
            TO_DEVICE  .UpdateValue ( "DEL PRESET " + Functions.ItoA (  (int) ( RX_DELETE_PRESET  .UshortValue ) ) + " RX " + Functions.ItoA (  (int) ( RX_ID  .Value ) ) + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object FROM_DEVICE_OnChange_50 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        CrestronString STR;
        STR  = new CrestronString( Crestron.Logos.SplusObjects.CrestronStringEncoding.eEncodingASCII, 256, this );
        
        ushort INDEX = 0;
        
        
        __context__.SourceCodeLine = 446;
        INDEX = (ushort) ( Functions.Find( "\u000D\u000A" , FROM_DEVICE ) ) ; 
        __context__.SourceCodeLine = 447;
        while ( Functions.TestForTrue  ( ( Functions.BoolToInt ( INDEX > 0 ))  ) ) 
            { 
            __context__.SourceCodeLine = 448;
            STR  .UpdateValue ( Functions.Remove ( "\u000D\u000A" , FROM_DEVICE , INDEX)  ) ; 
            __context__.SourceCodeLine = 450;
            if ( Functions.TestForTrue  ( ( DEBUGMODE  .Value)  ) ) 
                {
                __context__.SourceCodeLine = 450;
                Print( "[From_Device]str = {0}\r\n", STR ) ; 
                }
            
            __context__.SourceCodeLine = 451;
            Functions.ClearBuffer ( STR ) ; 
            __context__.SourceCodeLine = 452;
            INDEX = (ushort) ( Functions.Find( "\u000D\u000A" , FROM_DEVICE ) ) ; 
            __context__.SourceCodeLine = 447;
            } 
        
        __context__.SourceCodeLine = 456;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( Functions.Length( FROM_DEVICE ) > 0 ))  ) ) 
            { 
            __context__.SourceCodeLine = 458;
            Functions.ClearBuffer ( FROM_DEVICE ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

public override object FunctionMain (  object __obj__ ) 
    { 
    try
    {
        SplusExecutionContext __context__ = SplusFunctionMainStartCode();
        
        __context__.SourceCodeLine = 465;
        WaitForInitializationComplete ( ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler(); }
    return __obj__;
    }
    

public override void LogosSplusInitialize()
{
    SocketInfo __socketinfo__ = new SocketInfo( 1, this );
    InitialParametersClass.ResolveHostName = __socketinfo__.ResolveHostName;
    _SplusNVRAM = new SplusNVRAM( this );
    
    GET_RX_STATUS = new Crestron.Logos.SplusObjects.DigitalInput( GET_RX_STATUS__DigitalInput__, this );
    m_DigitalInputList.Add( GET_RX_STATUS__DigitalInput__, GET_RX_STATUS );
    
    RX_REBOOT = new Crestron.Logos.SplusObjects.DigitalInput( RX_REBOOT__DigitalInput__, this );
    m_DigitalInputList.Add( RX_REBOOT__DigitalInput__, RX_REBOOT );
    
    RX_LED_ON = new Crestron.Logos.SplusObjects.DigitalInput( RX_LED_ON__DigitalInput__, this );
    m_DigitalInputList.Add( RX_LED_ON__DigitalInput__, RX_LED_ON );
    
    RX_LED_OFF = new Crestron.Logos.SplusObjects.DigitalInput( RX_LED_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( RX_LED_OFF__DigitalInput__, RX_LED_OFF );
    
    RX_OUTPUT_ON = new Crestron.Logos.SplusObjects.DigitalInput( RX_OUTPUT_ON__DigitalInput__, this );
    m_DigitalInputList.Add( RX_OUTPUT_ON__DigitalInput__, RX_OUTPUT_ON );
    
    RX_OUTPUT_OFF = new Crestron.Logos.SplusObjects.DigitalInput( RX_OUTPUT_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( RX_OUTPUT_OFF__DigitalInput__, RX_OUTPUT_OFF );
    
    RX_OUTPUT_MUTE_ON = new Crestron.Logos.SplusObjects.DigitalInput( RX_OUTPUT_MUTE_ON__DigitalInput__, this );
    m_DigitalInputList.Add( RX_OUTPUT_MUTE_ON__DigitalInput__, RX_OUTPUT_MUTE_ON );
    
    RX_OUTPUT_MUTE_OFF = new Crestron.Logos.SplusObjects.DigitalInput( RX_OUTPUT_MUTE_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( RX_OUTPUT_MUTE_OFF__DigitalInput__, RX_OUTPUT_MUTE_OFF );
    
    RX_IR_VOL_5V = new Crestron.Logos.SplusObjects.DigitalInput( RX_IR_VOL_5V__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IR_VOL_5V__DigitalInput__, RX_IR_VOL_5V );
    
    RX_IR_VOL_12V = new Crestron.Logos.SplusObjects.DigitalInput( RX_IR_VOL_12V__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IR_VOL_12V__DigitalInput__, RX_IR_VOL_12V );
    
    RX_IO_VOL_5V = new Crestron.Logos.SplusObjects.DigitalInput( RX_IO_VOL_5V__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IO_VOL_5V__DigitalInput__, RX_IO_VOL_5V );
    
    RX_IO_VOL_12V = new Crestron.Logos.SplusObjects.DigitalInput( RX_IO_VOL_12V__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IO_VOL_12V__DigitalInput__, RX_IO_VOL_12V );
    
    RX_IO1_DIR_IN = new Crestron.Logos.SplusObjects.DigitalInput( RX_IO1_DIR_IN__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IO1_DIR_IN__DigitalInput__, RX_IO1_DIR_IN );
    
    RX_IO1_DIR_OUT = new Crestron.Logos.SplusObjects.DigitalInput( RX_IO1_DIR_OUT__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IO1_DIR_OUT__DigitalInput__, RX_IO1_DIR_OUT );
    
    RX_IO2_DIR_IN = new Crestron.Logos.SplusObjects.DigitalInput( RX_IO2_DIR_IN__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IO2_DIR_IN__DigitalInput__, RX_IO2_DIR_IN );
    
    RX_IO2_DIR_OUT = new Crestron.Logos.SplusObjects.DigitalInput( RX_IO2_DIR_OUT__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IO2_DIR_OUT__DigitalInput__, RX_IO2_DIR_OUT );
    
    RX_IO1_OUT_LOW = new Crestron.Logos.SplusObjects.DigitalInput( RX_IO1_OUT_LOW__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IO1_OUT_LOW__DigitalInput__, RX_IO1_OUT_LOW );
    
    RX_IO1_OUT_HIGH = new Crestron.Logos.SplusObjects.DigitalInput( RX_IO1_OUT_HIGH__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IO1_OUT_HIGH__DigitalInput__, RX_IO1_OUT_HIGH );
    
    RX_IO2_OUT_LOW = new Crestron.Logos.SplusObjects.DigitalInput( RX_IO2_OUT_LOW__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IO2_OUT_LOW__DigitalInput__, RX_IO2_OUT_LOW );
    
    RX_IO2_OUT_HIGH = new Crestron.Logos.SplusObjects.DigitalInput( RX_IO2_OUT_HIGH__DigitalInput__, this );
    m_DigitalInputList.Add( RX_IO2_OUT_HIGH__DigitalInput__, RX_IO2_OUT_HIGH );
    
    RX_RELAY1_OPEN = new Crestron.Logos.SplusObjects.DigitalInput( RX_RELAY1_OPEN__DigitalInput__, this );
    m_DigitalInputList.Add( RX_RELAY1_OPEN__DigitalInput__, RX_RELAY1_OPEN );
    
    RX_RELAY1_CLOSE = new Crestron.Logos.SplusObjects.DigitalInput( RX_RELAY1_CLOSE__DigitalInput__, this );
    m_DigitalInputList.Add( RX_RELAY1_CLOSE__DigitalInput__, RX_RELAY1_CLOSE );
    
    RX_RELAY2_OPEN = new Crestron.Logos.SplusObjects.DigitalInput( RX_RELAY2_OPEN__DigitalInput__, this );
    m_DigitalInputList.Add( RX_RELAY2_OPEN__DigitalInput__, RX_RELAY2_OPEN );
    
    RX_RELAY2_CLOSE = new Crestron.Logos.SplusObjects.DigitalInput( RX_RELAY2_CLOSE__DigitalInput__, this );
    m_DigitalInputList.Add( RX_RELAY2_CLOSE__DigitalInput__, RX_RELAY2_CLOSE );
    
    RX_FLIP_OFF = new Crestron.Logos.SplusObjects.DigitalInput( RX_FLIP_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( RX_FLIP_OFF__DigitalInput__, RX_FLIP_OFF );
    
    RX_FLIP_HOR = new Crestron.Logos.SplusObjects.DigitalInput( RX_FLIP_HOR__DigitalInput__, this );
    m_DigitalInputList.Add( RX_FLIP_HOR__DigitalInput__, RX_FLIP_HOR );
    
    RX_FLIP_VER = new Crestron.Logos.SplusObjects.DigitalInput( RX_FLIP_VER__DigitalInput__, this );
    m_DigitalInputList.Add( RX_FLIP_VER__DigitalInput__, RX_FLIP_VER );
    
    RX_ARP_ARC = new Crestron.Logos.SplusObjects.DigitalInput( RX_ARP_ARC__DigitalInput__, this );
    m_DigitalInputList.Add( RX_ARP_ARC__DigitalInput__, RX_ARP_ARC );
    
    RX_ARP_SPDIF = new Crestron.Logos.SplusObjects.DigitalInput( RX_ARP_SPDIF__DigitalInput__, this );
    m_DigitalInputList.Add( RX_ARP_SPDIF__DigitalInput__, RX_ARP_SPDIF );
    
    RX_EARC_ON = new Crestron.Logos.SplusObjects.DigitalInput( RX_EARC_ON__DigitalInput__, this );
    m_DigitalInputList.Add( RX_EARC_ON__DigitalInput__, RX_EARC_ON );
    
    RX_EARC_OFF = new Crestron.Logos.SplusObjects.DigitalInput( RX_EARC_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( RX_EARC_OFF__DigitalInput__, RX_EARC_OFF );
    
    RX_SAC_OFF = new Crestron.Logos.SplusObjects.DigitalInput( RX_SAC_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( RX_SAC_OFF__DigitalInput__, RX_SAC_OFF );
    
    RX_SAC_CEC = new Crestron.Logos.SplusObjects.DigitalInput( RX_SAC_CEC__DigitalInput__, this );
    m_DigitalInputList.Add( RX_SAC_CEC__DigitalInput__, RX_SAC_CEC );
    
    RX_SAC_ARC = new Crestron.Logos.SplusObjects.DigitalInput( RX_SAC_ARC__DigitalInput__, this );
    m_DigitalInputList.Add( RX_SAC_ARC__DigitalInput__, RX_SAC_ARC );
    
    RX_USB_ON = new Crestron.Logos.SplusObjects.DigitalInput( RX_USB_ON__DigitalInput__, this );
    m_DigitalInputList.Add( RX_USB_ON__DigitalInput__, RX_USB_ON );
    
    RX_USB_OFF = new Crestron.Logos.SplusObjects.DigitalInput( RX_USB_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( RX_USB_OFF__DigitalInput__, RX_USB_OFF );
    
    RX_OSD_MUTE_ON = new Crestron.Logos.SplusObjects.DigitalInput( RX_OSD_MUTE_ON__DigitalInput__, this );
    m_DigitalInputList.Add( RX_OSD_MUTE_ON__DigitalInput__, RX_OSD_MUTE_ON );
    
    RX_OSD_MUTE_OFF = new Crestron.Logos.SplusObjects.DigitalInput( RX_OSD_MUTE_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( RX_OSD_MUTE_OFF__DigitalInput__, RX_OSD_MUTE_OFF );
    
    RX_CYCLE_PLAY_ON = new Crestron.Logos.SplusObjects.DigitalInput( RX_CYCLE_PLAY_ON__DigitalInput__, this );
    m_DigitalInputList.Add( RX_CYCLE_PLAY_ON__DigitalInput__, RX_CYCLE_PLAY_ON );
    
    RX_CYCLE_PLAY_OFF = new Crestron.Logos.SplusObjects.DigitalInput( RX_CYCLE_PLAY_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( RX_CYCLE_PLAY_OFF__DigitalInput__, RX_CYCLE_PLAY_OFF );
    
    RX_SWITCH_TX = new Crestron.Logos.SplusObjects.AnalogInput( RX_SWITCH_TX__AnalogSerialInput__, this );
    m_AnalogInputList.Add( RX_SWITCH_TX__AnalogSerialInput__, RX_SWITCH_TX );
    
    RX_SWITCH_MODE = new Crestron.Logos.SplusObjects.AnalogInput( RX_SWITCH_MODE__AnalogSerialInput__, this );
    m_AnalogInputList.Add( RX_SWITCH_MODE__AnalogSerialInput__, RX_SWITCH_MODE );
    
    RX_OUTPUT_RESOLUTION = new Crestron.Logos.SplusObjects.AnalogInput( RX_OUTPUT_RESOLUTION__AnalogSerialInput__, this );
    m_AnalogInputList.Add( RX_OUTPUT_RESOLUTION__AnalogSerialInput__, RX_OUTPUT_RESOLUTION );
    
    RX_OUTPUT_ROTATE = new Crestron.Logos.SplusObjects.AnalogInput( RX_OUTPUT_ROTATE__AnalogSerialInput__, this );
    m_AnalogInputList.Add( RX_OUTPUT_ROTATE__AnalogSerialInput__, RX_OUTPUT_ROTATE );
    
    RX_OSD_CUSTOM = new Crestron.Logos.SplusObjects.AnalogInput( RX_OSD_CUSTOM__AnalogSerialInput__, this );
    m_AnalogInputList.Add( RX_OSD_CUSTOM__AnalogSerialInput__, RX_OSD_CUSTOM );
    
    RX_CYCLE_PLAY_INTERVAL = new Crestron.Logos.SplusObjects.AnalogInput( RX_CYCLE_PLAY_INTERVAL__AnalogSerialInput__, this );
    m_AnalogInputList.Add( RX_CYCLE_PLAY_INTERVAL__AnalogSerialInput__, RX_CYCLE_PLAY_INTERVAL );
    
    RX_CYCLE_PLAY_SRC = new Crestron.Logos.SplusObjects.AnalogInput( RX_CYCLE_PLAY_SRC__AnalogSerialInput__, this );
    m_AnalogInputList.Add( RX_CYCLE_PLAY_SRC__AnalogSerialInput__, RX_CYCLE_PLAY_SRC );
    
    RX_DELETE_PRESET = new Crestron.Logos.SplusObjects.AnalogInput( RX_DELETE_PRESET__AnalogSerialInput__, this );
    m_AnalogInputList.Add( RX_DELETE_PRESET__AnalogSerialInput__, RX_DELETE_PRESET );
    
    RX_ADD_PRESET = new InOutArray<AnalogInput>( 10, this );
    for( uint i = 0; i < 10; i++ )
    {
        RX_ADD_PRESET[i+1] = new Crestron.Logos.SplusObjects.AnalogInput( RX_ADD_PRESET__AnalogSerialInput__ + i, RX_ADD_PRESET__AnalogSerialInput__, this );
        m_AnalogInputList.Add( RX_ADD_PRESET__AnalogSerialInput__ + i, RX_ADD_PRESET[i+1] );
    }
    
    RX_NAME = new Crestron.Logos.SplusObjects.StringInput( RX_NAME__AnalogSerialInput__, 16, this );
    m_StringInputList.Add( RX_NAME__AnalogSerialInput__, RX_NAME );
    
    TO_DEVICE = new Crestron.Logos.SplusObjects.StringOutput( TO_DEVICE__AnalogSerialOutput__, this );
    m_StringOutputList.Add( TO_DEVICE__AnalogSerialOutput__, TO_DEVICE );
    
    FROM_DEVICE = new Crestron.Logos.SplusObjects.BufferInput( FROM_DEVICE__AnalogSerialInput__, 4096, this );
    m_StringInputList.Add( FROM_DEVICE__AnalogSerialInput__, FROM_DEVICE );
    
    DEBUGMODE = new UShortParameter( DEBUGMODE__Parameter__, this );
    m_ParameterList.Add( DEBUGMODE__Parameter__, DEBUGMODE );
    
    RX_ID = new UShortParameter( RX_ID__Parameter__, this );
    m_ParameterList.Add( RX_ID__Parameter__, RX_ID );
    
    
    GET_RX_STATUS.OnDigitalPush.Add( new InputChangeHandlerWrapper( GET_RX_STATUS_OnPush_0, false ) );
    RX_REBOOT.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_REBOOT_OnPush_1, false ) );
    RX_LED_ON.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_LED_ON_OnPush_2, false ) );
    RX_LED_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_LED_OFF_OnPush_3, false ) );
    RX_OUTPUT_ON.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_OUTPUT_ON_OnPush_4, false ) );
    RX_OUTPUT_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_OUTPUT_OFF_OnPush_5, false ) );
    RX_OUTPUT_MUTE_ON.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_OUTPUT_MUTE_ON_OnPush_6, false ) );
    RX_OUTPUT_MUTE_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_OUTPUT_MUTE_OFF_OnPush_7, false ) );
    RX_IR_VOL_5V.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IR_VOL_5V_OnPush_8, false ) );
    RX_IR_VOL_12V.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IR_VOL_12V_OnPush_9, false ) );
    RX_IO_VOL_5V.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IO_VOL_5V_OnPush_10, false ) );
    RX_IO_VOL_12V.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IO_VOL_12V_OnPush_11, false ) );
    RX_IO1_DIR_IN.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IO1_DIR_IN_OnPush_12, false ) );
    RX_IO1_DIR_OUT.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IO1_DIR_OUT_OnPush_13, false ) );
    RX_IO2_DIR_IN.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IO2_DIR_IN_OnPush_14, false ) );
    RX_IO2_DIR_OUT.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IO2_DIR_OUT_OnPush_15, false ) );
    RX_IO1_OUT_LOW.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IO1_OUT_LOW_OnPush_16, false ) );
    RX_IO1_OUT_HIGH.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IO1_OUT_HIGH_OnPush_17, false ) );
    RX_IO2_OUT_LOW.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IO2_OUT_LOW_OnPush_18, false ) );
    RX_IO2_OUT_HIGH.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_IO2_OUT_HIGH_OnPush_19, false ) );
    RX_RELAY1_OPEN.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_RELAY1_OPEN_OnPush_20, false ) );
    RX_RELAY1_CLOSE.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_RELAY1_CLOSE_OnPush_21, false ) );
    RX_RELAY2_OPEN.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_RELAY2_OPEN_OnPush_22, false ) );
    RX_RELAY2_CLOSE.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_RELAY2_CLOSE_OnPush_23, false ) );
    RX_FLIP_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_FLIP_OFF_OnPush_24, false ) );
    RX_FLIP_HOR.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_FLIP_HOR_OnPush_25, false ) );
    RX_FLIP_VER.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_FLIP_VER_OnPush_26, false ) );
    RX_ARP_ARC.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_ARP_ARC_OnPush_27, false ) );
    RX_ARP_SPDIF.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_ARP_SPDIF_OnPush_28, false ) );
    RX_EARC_ON.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_EARC_ON_OnPush_29, false ) );
    RX_EARC_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_EARC_OFF_OnPush_30, false ) );
    RX_SAC_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_SAC_OFF_OnPush_31, false ) );
    RX_SAC_CEC.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_SAC_CEC_OnPush_32, false ) );
    RX_SAC_ARC.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_SAC_ARC_OnPush_33, false ) );
    RX_USB_ON.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_USB_ON_OnPush_34, false ) );
    RX_USB_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_USB_OFF_OnPush_35, false ) );
    RX_OSD_MUTE_ON.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_OSD_MUTE_ON_OnPush_36, false ) );
    RX_OSD_MUTE_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_OSD_MUTE_OFF_OnPush_37, false ) );
    RX_CYCLE_PLAY_ON.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_CYCLE_PLAY_ON_OnPush_38, false ) );
    RX_CYCLE_PLAY_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( RX_CYCLE_PLAY_OFF_OnPush_39, false ) );
    RX_OSD_CUSTOM.OnAnalogChange.Add( new InputChangeHandlerWrapper( RX_OSD_CUSTOM_OnChange_40, false ) );
    RX_CYCLE_PLAY_INTERVAL.OnAnalogChange.Add( new InputChangeHandlerWrapper( RX_CYCLE_PLAY_INTERVAL_OnChange_41, false ) );
    RX_CYCLE_PLAY_SRC.OnAnalogChange.Add( new InputChangeHandlerWrapper( RX_CYCLE_PLAY_SRC_OnChange_42, false ) );
    RX_NAME.OnSerialChange.Add( new InputChangeHandlerWrapper( RX_NAME_OnChange_43, false ) );
    RX_SWITCH_TX.OnAnalogChange.Add( new InputChangeHandlerWrapper( RX_SWITCH_TX_OnChange_44, false ) );
    RX_SWITCH_MODE.OnAnalogChange.Add( new InputChangeHandlerWrapper( RX_SWITCH_MODE_OnChange_45, false ) );
    RX_OUTPUT_RESOLUTION.OnAnalogChange.Add( new InputChangeHandlerWrapper( RX_OUTPUT_RESOLUTION_OnChange_46, false ) );
    RX_OUTPUT_ROTATE.OnAnalogChange.Add( new InputChangeHandlerWrapper( RX_OUTPUT_ROTATE_OnChange_47, false ) );
    for( uint i = 0; i < 10; i++ )
        RX_ADD_PRESET[i+1].OnAnalogChange.Add( new InputChangeHandlerWrapper( RX_ADD_PRESET_OnChange_48, false ) );
        
    RX_DELETE_PRESET.OnAnalogChange.Add( new InputChangeHandlerWrapper( RX_DELETE_PRESET_OnChange_49, false ) );
    FROM_DEVICE.OnSerialChange.Add( new InputChangeHandlerWrapper( FROM_DEVICE_OnChange_50, true ) );
    
    _SplusNVRAM.PopulateCustomAttributeList( true );
    
    NVRAM = _SplusNVRAM;
    
}

public override void LogosSimplSharpInitialize()
{
    
    
}

public UserModuleClass_RECEIVER_CN_AV_V1 ( string InstanceName, string ReferenceID, Crestron.Logos.SplusObjects.CrestronStringEncoding nEncodingType ) : base( InstanceName, ReferenceID, nEncodingType ) {}




const uint GET_RX_STATUS__DigitalInput__ = 0;
const uint RX_REBOOT__DigitalInput__ = 1;
const uint RX_LED_ON__DigitalInput__ = 2;
const uint RX_LED_OFF__DigitalInput__ = 3;
const uint RX_OUTPUT_ON__DigitalInput__ = 4;
const uint RX_OUTPUT_OFF__DigitalInput__ = 5;
const uint RX_OUTPUT_MUTE_ON__DigitalInput__ = 6;
const uint RX_OUTPUT_MUTE_OFF__DigitalInput__ = 7;
const uint RX_IR_VOL_5V__DigitalInput__ = 8;
const uint RX_IR_VOL_12V__DigitalInput__ = 9;
const uint RX_IO_VOL_5V__DigitalInput__ = 10;
const uint RX_IO_VOL_12V__DigitalInput__ = 11;
const uint RX_IO1_DIR_IN__DigitalInput__ = 12;
const uint RX_IO1_DIR_OUT__DigitalInput__ = 13;
const uint RX_IO2_DIR_IN__DigitalInput__ = 14;
const uint RX_IO2_DIR_OUT__DigitalInput__ = 15;
const uint RX_IO1_OUT_LOW__DigitalInput__ = 16;
const uint RX_IO1_OUT_HIGH__DigitalInput__ = 17;
const uint RX_IO2_OUT_LOW__DigitalInput__ = 18;
const uint RX_IO2_OUT_HIGH__DigitalInput__ = 19;
const uint RX_RELAY1_OPEN__DigitalInput__ = 20;
const uint RX_RELAY1_CLOSE__DigitalInput__ = 21;
const uint RX_RELAY2_OPEN__DigitalInput__ = 22;
const uint RX_RELAY2_CLOSE__DigitalInput__ = 23;
const uint RX_FLIP_OFF__DigitalInput__ = 24;
const uint RX_FLIP_HOR__DigitalInput__ = 25;
const uint RX_FLIP_VER__DigitalInput__ = 26;
const uint RX_ARP_ARC__DigitalInput__ = 27;
const uint RX_ARP_SPDIF__DigitalInput__ = 28;
const uint RX_EARC_ON__DigitalInput__ = 29;
const uint RX_EARC_OFF__DigitalInput__ = 30;
const uint RX_SAC_OFF__DigitalInput__ = 31;
const uint RX_SAC_CEC__DigitalInput__ = 32;
const uint RX_SAC_ARC__DigitalInput__ = 33;
const uint RX_USB_ON__DigitalInput__ = 34;
const uint RX_USB_OFF__DigitalInput__ = 35;
const uint RX_OSD_MUTE_ON__DigitalInput__ = 36;
const uint RX_OSD_MUTE_OFF__DigitalInput__ = 37;
const uint RX_CYCLE_PLAY_ON__DigitalInput__ = 38;
const uint RX_CYCLE_PLAY_OFF__DigitalInput__ = 39;
const uint RX_NAME__AnalogSerialInput__ = 0;
const uint FROM_DEVICE__AnalogSerialInput__ = 1;
const uint RX_SWITCH_TX__AnalogSerialInput__ = 2;
const uint RX_SWITCH_MODE__AnalogSerialInput__ = 3;
const uint RX_OUTPUT_RESOLUTION__AnalogSerialInput__ = 4;
const uint RX_OUTPUT_ROTATE__AnalogSerialInput__ = 5;
const uint RX_OSD_CUSTOM__AnalogSerialInput__ = 6;
const uint RX_CYCLE_PLAY_INTERVAL__AnalogSerialInput__ = 7;
const uint RX_CYCLE_PLAY_SRC__AnalogSerialInput__ = 8;
const uint RX_DELETE_PRESET__AnalogSerialInput__ = 9;
const uint RX_ADD_PRESET__AnalogSerialInput__ = 10;
const uint TO_DEVICE__AnalogSerialOutput__ = 0;
const uint DEBUGMODE__Parameter__ = 10;
const uint RX_ID__Parameter__ = 11;

[SplusStructAttribute(-1, true, false)]
public class SplusNVRAM : SplusStructureBase
{

    public SplusNVRAM( SplusObject __caller__ ) : base( __caller__ ) {}
    
    
}

SplusNVRAM _SplusNVRAM = null;

public class __CEvent__ : CEvent
{
    public __CEvent__() {}
    public void Close() { base.Close(); }
    public int Reset() { return base.Reset() ? 1 : 0; }
    public int Set() { return base.Set() ? 1 : 0; }
    public int Wait( int timeOutInMs ) { return base.Wait( timeOutInMs ) ? 1 : 0; }
}
public class __CMutex__ : CMutex
{
    public __CMutex__() {}
    public void Close() { base.Close(); }
    public void ReleaseMutex() { base.ReleaseMutex(); }
    public int WaitForMutex() { return base.WaitForMutex() ? 1 : 0; }
}
 public int IsNull( object obj ){ return (obj == null) ? 1 : 0; }
}


}
