using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Linq;
using Crestron;
using Crestron.Logos.SplusLibrary;
using Crestron.Logos.SplusObjects;
using Crestron.SimplSharp;

namespace UserModule_VIDEO_WALL_CN_AV_V1
{
    public class UserModuleClass_VIDEO_WALL_CN_AV_V1 : SplusObject
    {
        static CCriticalSection g_criticalSection = new CCriticalSection();
        
        
        
        
        Crestron.Logos.SplusObjects.DigitalInput GET_VIDEO_WALL_STATUS;
        Crestron.Logos.SplusObjects.DigitalInput CREATE_VIDEO_WALL;
        Crestron.Logos.SplusObjects.DigitalInput DELETE_VIDEO_WALL;
        Crestron.Logos.SplusObjects.DigitalInput ACTIVATE_VIDEO_WALL;
        Crestron.Logos.SplusObjects.DigitalInput DEACTIVATE_VIDEO_WALL;
        Crestron.Logos.SplusObjects.AnalogInput DELETE_VIDEOWALL_PRESET;
        Crestron.Logos.SplusObjects.AnalogInput ADD_VIDEOWALL_PRESET;
        Crestron.Logos.SplusObjects.AnalogInput APPLY_VIDEOWALL_PRESET;
        Crestron.Logos.SplusObjects.StringInput VIDEO_WALL_NAME;
        Crestron.Logos.SplusObjects.BufferInput FROM_DEVICE;
        Crestron.Logos.SplusObjects.StringOutput TO_DEVICE;
        UShortParameter DEBUGMODE;
        UShortParameter VW_HANDLER;
        UShortParameter VW_ROW;
        UShortParameter VW_COLUMN;
        object GET_VIDEO_WALL_STATUS_OnPush_0 ( Object __EventInfo__ )
        
            { 
            Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
            try
            {
                SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
                
                __context__.SourceCodeLine = 131;
                TO_DEVICE  .UpdateValue ( "R WALL " + Functions.ItoA (  (int) ( VW_HANDLER  .Value ) ) + " STATUS" + "\u000D\u000A"  ) ; 
                
                
            }
            catch(Exception e) { ObjectCatchHandler(e); }
            finally { ObjectFinallyHandler( __SignalEventArg__ ); }
            return this;
            
        }
        
    object CREATE_VIDEO_WALL_OnPush_1 ( Object __EventInfo__ )
    
        { 
        Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
        try
        {
            SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
            
            __context__.SourceCodeLine = 135;
            TO_DEVICE  .UpdateValue ( "CRE WALL " + Functions.ItoA (  (int) ( VW_HANDLER  .Value ) ) + "\u000D\u000A"  ) ; 
            __context__.SourceCodeLine = 136;
            Functions.Delay (  (int) ( 10 ) ) ; 
            __context__.SourceCodeLine = 137;
            TO_DEVICE  .UpdateValue ( "S WALL " + Functions.ItoA (  (int) ( VW_HANDLER  .Value ) ) + " C " + Functions.ItoA (  (int) ( VW_COLUMN  .Value ) ) + " R " + Functions.ItoA (  (int) ( VW_ROW  .Value ) ) + "\u000D\u000A"  ) ; 
            
            
        }
        catch(Exception e) { ObjectCatchHandler(e); }
        finally { ObjectFinallyHandler( __SignalEventArg__ ); }
        return this;
        
    }
    
object VIDEO_WALL_NAME_OnChange_2 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 141;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( Functions.Length( VIDEO_WALL_NAME ) > 0 ))  ) ) 
            { 
            __context__.SourceCodeLine = 143;
            TO_DEVICE  .UpdateValue ( "S WALL " + Functions.ItoA (  (int) ( VW_HANDLER  .Value ) ) + " NAME " + VIDEO_WALL_NAME + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object ACTIVATE_VIDEO_WALL_OnPush_3 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 149;
        TO_DEVICE  .UpdateValue ( "S WALL " + Functions.ItoA (  (int) ( VW_HANDLER  .Value ) ) + " APPLY" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object DEACTIVATE_VIDEO_WALL_OnPush_4 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 153;
        TO_DEVICE  .UpdateValue ( "S WALL " + Functions.ItoA (  (int) ( VW_HANDLER  .Value ) ) + " DEACT" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object DELETE_VIDEO_WALL_OnPush_5 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 157;
        TO_DEVICE  .UpdateValue ( "DEL WALL " + Functions.ItoA (  (int) ( VW_HANDLER  .Value ) ) + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object APPLY_VIDEOWALL_PRESET_OnChange_6 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 161;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( APPLY_VIDEOWALL_PRESET  .UshortValue > 0 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( APPLY_VIDEOWALL_PRESET  .UshortValue < 11 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 163;
            TO_DEVICE  .UpdateValue ( "S PRESET " + Functions.ItoA (  (int) ( APPLY_VIDEOWALL_PRESET  .UshortValue ) ) + " APPLY" + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object ADD_VIDEOWALL_PRESET_OnChange_7 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 169;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( ADD_VIDEOWALL_PRESET  .UshortValue > 0 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( ADD_VIDEOWALL_PRESET  .UshortValue < 11 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 171;
            TO_DEVICE  .UpdateValue ( "ADD PRESET " + Functions.ItoA (  (int) ( ADD_VIDEOWALL_PRESET  .UshortValue ) ) + " WALL " + Functions.ItoA (  (int) ( VW_HANDLER  .Value ) ) + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object DELETE_VIDEOWALL_PRESET_OnChange_8 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 176;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( DELETE_VIDEOWALL_PRESET  .UshortValue > 0 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( DELETE_VIDEOWALL_PRESET  .UshortValue < 11 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 178;
            TO_DEVICE  .UpdateValue ( "DEL PRESET " + Functions.ItoA (  (int) ( DELETE_VIDEOWALL_PRESET  .UshortValue ) ) + " WALL " + Functions.ItoA (  (int) ( VW_HANDLER  .Value ) ) + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object FROM_DEVICE_OnChange_9 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        CrestronString STR;
        STR  = new CrestronString( Crestron.Logos.SplusObjects.CrestronStringEncoding.eEncodingASCII, 256, this );
        
        ushort INDEX = 0;
        
        
        __context__.SourceCodeLine = 186;
        INDEX = (ushort) ( Functions.Find( "\u000D\u000A" , FROM_DEVICE ) ) ; 
        __context__.SourceCodeLine = 187;
        while ( Functions.TestForTrue  ( ( Functions.BoolToInt ( INDEX > 0 ))  ) ) 
            { 
            __context__.SourceCodeLine = 188;
            STR  .UpdateValue ( Functions.Remove ( "\u000D\u000A" , FROM_DEVICE , INDEX)  ) ; 
            __context__.SourceCodeLine = 190;
            if ( Functions.TestForTrue  ( ( DEBUGMODE  .Value)  ) ) 
                {
                __context__.SourceCodeLine = 190;
                Print( "[From_Device]str = {0}\r\n", STR ) ; 
                }
            
            __context__.SourceCodeLine = 191;
            Functions.ClearBuffer ( STR ) ; 
            __context__.SourceCodeLine = 192;
            INDEX = (ushort) ( Functions.Find( "\u000D\u000A" , FROM_DEVICE ) ) ; 
            __context__.SourceCodeLine = 187;
            } 
        
        __context__.SourceCodeLine = 196;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( Functions.Length( FROM_DEVICE ) > 0 ))  ) ) 
            { 
            __context__.SourceCodeLine = 198;
            Functions.ClearBuffer ( FROM_DEVICE ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

public override object FunctionMain (  object __obj__ ) 
    { 
    try
    {
        SplusExecutionContext __context__ = SplusFunctionMainStartCode();
        
        __context__.SourceCodeLine = 205;
        WaitForInitializationComplete ( ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler(); }
    return __obj__;
    }
    

public override void LogosSplusInitialize()
{
    SocketInfo __socketinfo__ = new SocketInfo( 1, this );
    InitialParametersClass.ResolveHostName = __socketinfo__.ResolveHostName;
    _SplusNVRAM = new SplusNVRAM( this );
    
    GET_VIDEO_WALL_STATUS = new Crestron.Logos.SplusObjects.DigitalInput( GET_VIDEO_WALL_STATUS__DigitalInput__, this );
    m_DigitalInputList.Add( GET_VIDEO_WALL_STATUS__DigitalInput__, GET_VIDEO_WALL_STATUS );
    
    CREATE_VIDEO_WALL = new Crestron.Logos.SplusObjects.DigitalInput( CREATE_VIDEO_WALL__DigitalInput__, this );
    m_DigitalInputList.Add( CREATE_VIDEO_WALL__DigitalInput__, CREATE_VIDEO_WALL );
    
    DELETE_VIDEO_WALL = new Crestron.Logos.SplusObjects.DigitalInput( DELETE_VIDEO_WALL__DigitalInput__, this );
    m_DigitalInputList.Add( DELETE_VIDEO_WALL__DigitalInput__, DELETE_VIDEO_WALL );
    
    ACTIVATE_VIDEO_WALL = new Crestron.Logos.SplusObjects.DigitalInput( ACTIVATE_VIDEO_WALL__DigitalInput__, this );
    m_DigitalInputList.Add( ACTIVATE_VIDEO_WALL__DigitalInput__, ACTIVATE_VIDEO_WALL );
    
    DEACTIVATE_VIDEO_WALL = new Crestron.Logos.SplusObjects.DigitalInput( DEACTIVATE_VIDEO_WALL__DigitalInput__, this );
    m_DigitalInputList.Add( DEACTIVATE_VIDEO_WALL__DigitalInput__, DEACTIVATE_VIDEO_WALL );
    
    DELETE_VIDEOWALL_PRESET = new Crestron.Logos.SplusObjects.AnalogInput( DELETE_VIDEOWALL_PRESET__AnalogSerialInput__, this );
    m_AnalogInputList.Add( DELETE_VIDEOWALL_PRESET__AnalogSerialInput__, DELETE_VIDEOWALL_PRESET );
    
    ADD_VIDEOWALL_PRESET = new Crestron.Logos.SplusObjects.AnalogInput( ADD_VIDEOWALL_PRESET__AnalogSerialInput__, this );
    m_AnalogInputList.Add( ADD_VIDEOWALL_PRESET__AnalogSerialInput__, ADD_VIDEOWALL_PRESET );
    
    APPLY_VIDEOWALL_PRESET = new Crestron.Logos.SplusObjects.AnalogInput( APPLY_VIDEOWALL_PRESET__AnalogSerialInput__, this );
    m_AnalogInputList.Add( APPLY_VIDEOWALL_PRESET__AnalogSerialInput__, APPLY_VIDEOWALL_PRESET );
    
    VIDEO_WALL_NAME = new Crestron.Logos.SplusObjects.StringInput( VIDEO_WALL_NAME__AnalogSerialInput__, 16, this );
    m_StringInputList.Add( VIDEO_WALL_NAME__AnalogSerialInput__, VIDEO_WALL_NAME );
    
    TO_DEVICE = new Crestron.Logos.SplusObjects.StringOutput( TO_DEVICE__AnalogSerialOutput__, this );
    m_StringOutputList.Add( TO_DEVICE__AnalogSerialOutput__, TO_DEVICE );
    
    FROM_DEVICE = new Crestron.Logos.SplusObjects.BufferInput( FROM_DEVICE__AnalogSerialInput__, 4096, this );
    m_StringInputList.Add( FROM_DEVICE__AnalogSerialInput__, FROM_DEVICE );
    
    DEBUGMODE = new UShortParameter( DEBUGMODE__Parameter__, this );
    m_ParameterList.Add( DEBUGMODE__Parameter__, DEBUGMODE );
    
    VW_HANDLER = new UShortParameter( VW_HANDLER__Parameter__, this );
    m_ParameterList.Add( VW_HANDLER__Parameter__, VW_HANDLER );
    
    VW_ROW = new UShortParameter( VW_ROW__Parameter__, this );
    m_ParameterList.Add( VW_ROW__Parameter__, VW_ROW );
    
    VW_COLUMN = new UShortParameter( VW_COLUMN__Parameter__, this );
    m_ParameterList.Add( VW_COLUMN__Parameter__, VW_COLUMN );
    
    
    GET_VIDEO_WALL_STATUS.OnDigitalPush.Add( new InputChangeHandlerWrapper( GET_VIDEO_WALL_STATUS_OnPush_0, false ) );
    CREATE_VIDEO_WALL.OnDigitalPush.Add( new InputChangeHandlerWrapper( CREATE_VIDEO_WALL_OnPush_1, false ) );
    VIDEO_WALL_NAME.OnSerialChange.Add( new InputChangeHandlerWrapper( VIDEO_WALL_NAME_OnChange_2, false ) );
    ACTIVATE_VIDEO_WALL.OnDigitalPush.Add( new InputChangeHandlerWrapper( ACTIVATE_VIDEO_WALL_OnPush_3, false ) );
    DEACTIVATE_VIDEO_WALL.OnDigitalPush.Add( new InputChangeHandlerWrapper( DEACTIVATE_VIDEO_WALL_OnPush_4, false ) );
    DELETE_VIDEO_WALL.OnDigitalPush.Add( new InputChangeHandlerWrapper( DELETE_VIDEO_WALL_OnPush_5, false ) );
    APPLY_VIDEOWALL_PRESET.OnAnalogChange.Add( new InputChangeHandlerWrapper( APPLY_VIDEOWALL_PRESET_OnChange_6, false ) );
    ADD_VIDEOWALL_PRESET.OnAnalogChange.Add( new InputChangeHandlerWrapper( ADD_VIDEOWALL_PRESET_OnChange_7, false ) );
    DELETE_VIDEOWALL_PRESET.OnAnalogChange.Add( new InputChangeHandlerWrapper( DELETE_VIDEOWALL_PRESET_OnChange_8, false ) );
    FROM_DEVICE.OnSerialChange.Add( new InputChangeHandlerWrapper( FROM_DEVICE_OnChange_9, true ) );
    
    _SplusNVRAM.PopulateCustomAttributeList( true );
    
    NVRAM = _SplusNVRAM;
    
}

public override void LogosSimplSharpInitialize()
{
    
    
}

public UserModuleClass_VIDEO_WALL_CN_AV_V1 ( string InstanceName, string ReferenceID, Crestron.Logos.SplusObjects.CrestronStringEncoding nEncodingType ) : base( InstanceName, ReferenceID, nEncodingType ) {}




const uint GET_VIDEO_WALL_STATUS__DigitalInput__ = 0;
const uint CREATE_VIDEO_WALL__DigitalInput__ = 1;
const uint DELETE_VIDEO_WALL__DigitalInput__ = 2;
const uint ACTIVATE_VIDEO_WALL__DigitalInput__ = 3;
const uint DEACTIVATE_VIDEO_WALL__DigitalInput__ = 4;
const uint DELETE_VIDEOWALL_PRESET__AnalogSerialInput__ = 0;
const uint ADD_VIDEOWALL_PRESET__AnalogSerialInput__ = 1;
const uint APPLY_VIDEOWALL_PRESET__AnalogSerialInput__ = 2;
const uint VIDEO_WALL_NAME__AnalogSerialInput__ = 3;
const uint FROM_DEVICE__AnalogSerialInput__ = 4;
const uint TO_DEVICE__AnalogSerialOutput__ = 0;
const uint DEBUGMODE__Parameter__ = 10;
const uint VW_HANDLER__Parameter__ = 11;
const uint VW_ROW__Parameter__ = 12;
const uint VW_COLUMN__Parameter__ = 13;

[SplusStructAttribute(-1, true, false)]
public class SplusNVRAM : SplusStructureBase
{

    public SplusNVRAM( SplusObject __caller__ ) : base( __caller__ ) {}
    
    
}

SplusNVRAM _SplusNVRAM = null;

public class __CEvent__ : CEvent
{
    public __CEvent__() {}
    public void Close() { base.Close(); }
    public int Reset() { return base.Reset() ? 1 : 0; }
    public int Set() { return base.Set() ? 1 : 0; }
    public int Wait( int timeOutInMs ) { return base.Wait( timeOutInMs ) ? 1 : 0; }
}
public class __CMutex__ : CMutex
{
    public __CMutex__() {}
    public void Close() { base.Close(); }
    public void ReleaseMutex() { base.ReleaseMutex(); }
    public int WaitForMutex() { return base.WaitForMutex() ? 1 : 0; }
}
 public int IsNull( object obj ){ return (obj == null) ? 1 : 0; }
}


}
