using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Linq;
using Crestron;
using Crestron.Logos.SplusLibrary;
using Crestron.Logos.SplusObjects;
using Crestron.SimplSharp;

namespace UserModule_TRANSMITTER_CN_AV_V1
{
    public class UserModuleClass_TRANSMITTER_CN_AV_V1 : SplusObject
    {
        static CCriticalSection g_criticalSection = new CCriticalSection();
        
        
        
        
        Crestron.Logos.SplusObjects.DigitalInput GET_TX_STATUS;
        Crestron.Logos.SplusObjects.DigitalInput TX_REBOOT;
        Crestron.Logos.SplusObjects.DigitalInput TX_LED_ON;
        Crestron.Logos.SplusObjects.DigitalInput TX_LED_OFF;
        Crestron.Logos.SplusObjects.DigitalInput TX_PREVIEW_ON;
        Crestron.Logos.SplusObjects.DigitalInput TX_SIGNAL_MUTE_ON;
        Crestron.Logos.SplusObjects.DigitalInput TX_SIGNAL_MUTE_OFF;
        Crestron.Logos.SplusObjects.DigitalInput TX_AUDIO_INPUT_HDMI;
        Crestron.Logos.SplusObjects.DigitalInput TX_AUDIO_INPUT_ANA;
        Crestron.Logos.SplusObjects.DigitalInput TX_IR_VOL_5V;
        Crestron.Logos.SplusObjects.DigitalInput TX_IR_VOL_12V;
        Crestron.Logos.SplusObjects.DigitalInput TX_IO_VOL_5V;
        Crestron.Logos.SplusObjects.DigitalInput TX_IO_VOL_12V;
        Crestron.Logos.SplusObjects.DigitalInput TX_IO1_DIR_IN;
        Crestron.Logos.SplusObjects.DigitalInput TX_IO1_DIR_OUT;
        Crestron.Logos.SplusObjects.DigitalInput TX_IO2_DIR_IN;
        Crestron.Logos.SplusObjects.DigitalInput TX_IO2_DIR_OUT;
        Crestron.Logos.SplusObjects.DigitalInput TX_IO1_OUT_LOW;
        Crestron.Logos.SplusObjects.DigitalInput TX_IO1_OUT_HIGH;
        Crestron.Logos.SplusObjects.DigitalInput TX_IO2_OUT_LOW;
        Crestron.Logos.SplusObjects.DigitalInput TX_IO2_OUT_HIGH;
        Crestron.Logos.SplusObjects.DigitalInput TX_RELAY1_OPEN;
        Crestron.Logos.SplusObjects.DigitalInput TX_RELAY1_CLOSE;
        Crestron.Logos.SplusObjects.DigitalInput TX_RELAY2_OPEN;
        Crestron.Logos.SplusObjects.DigitalInput TX_RELAY2_CLOSE;
        Crestron.Logos.SplusObjects.DigitalInput TX_SAC_OFF;
        Crestron.Logos.SplusObjects.DigitalInput TX_SAC_CEC;
        Crestron.Logos.SplusObjects.DigitalInput TX_SAC_ARC;
        Crestron.Logos.SplusObjects.AnalogInput TX_PREVIEW_PHOTO;
        Crestron.Logos.SplusObjects.AnalogInput TX_ARC_SWITCH_DEC;
        Crestron.Logos.SplusObjects.StringInput TX_NAME;
        Crestron.Logos.SplusObjects.BufferInput FROM_DEVICE;
        Crestron.Logos.SplusObjects.StringOutput TO_DEVICE;
        UShortParameter DEBUGMODE;
        UShortParameter TX_ID;
        object GET_TX_STATUS_OnPush_0 ( Object __EventInfo__ )
        
            { 
            Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
            try
            {
                SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
                
                __context__.SourceCodeLine = 123;
                TO_DEVICE  .UpdateValue ( "R TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " STATUS" + "\u000D\u000A"  ) ; 
                
                
            }
            catch(Exception e) { ObjectCatchHandler(e); }
            finally { ObjectFinallyHandler( __SignalEventArg__ ); }
            return this;
            
        }
        
    object TX_REBOOT_OnPush_1 ( Object __EventInfo__ )
    
        { 
        Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
        try
        {
            SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
            
            __context__.SourceCodeLine = 127;
            TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " REBOOT" + "\u000D\u000A"  ) ; 
            
            
        }
        catch(Exception e) { ObjectCatchHandler(e); }
        finally { ObjectFinallyHandler( __SignalEventArg__ ); }
        return this;
        
    }
    
object TX_LED_ON_OnPush_2 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 132;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " LED ON" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_LED_OFF_OnPush_3 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 137;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " LED OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_PREVIEW_ON_OnPush_4 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 142;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " PREVIEW ON" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_PREVIEW_PHOTO_OnChange_5 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 148;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( (Functions.TestForTrue ( Functions.BoolToInt ( TX_PREVIEW_PHOTO  .UshortValue > 0 ) ) && Functions.TestForTrue ( Functions.BoolToInt ( TX_PREVIEW_PHOTO  .UshortValue <= 17 ) )) ))  ) ) 
            { 
            __context__.SourceCodeLine = 150;
            TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " PREVIEW " + Functions.ItoA (  (int) ( TX_PREVIEW_PHOTO  .UshortValue ) ) + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_SIGNAL_MUTE_ON_OnPush_6 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 156;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " MUTE ON" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_SIGNAL_MUTE_OFF_OnPush_7 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 161;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " MUTE OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_AUDIO_INPUT_HDMI_OnPush_8 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 166;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " AUDIO INPUT HDMI" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_AUDIO_INPUT_ANA_OnPush_9 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 171;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " AUDIO INPUT ANA" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IR_VOL_5V_OnPush_10 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 176;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IR VOL 5V" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IR_VOL_12V_OnPush_11 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 181;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IR VOL 12V" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IO_VOL_5V_OnPush_12 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 186;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IO VOL 5V" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IO_VOL_12V_OnPush_13 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 191;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IO VOL 12V" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IO1_DIR_IN_OnPush_14 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 196;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IO 1 DIR IN" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IO1_DIR_OUT_OnPush_15 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 201;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IO 1 DIR OUT" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IO2_DIR_IN_OnPush_16 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 206;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IO 2 DIR IN" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IO2_DIR_OUT_OnPush_17 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 211;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IO 2 DIR OUT" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IO1_OUT_LOW_OnPush_18 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 216;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IO 1 OUT 0" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IO1_OUT_HIGH_OnPush_19 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 221;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IO 1 OUT 1" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IO2_OUT_LOW_OnPush_20 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 226;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IO 2 OUT 0" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_IO2_OUT_HIGH_OnPush_21 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 230;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " IO 2 OUT 1" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_RELAY1_OPEN_OnPush_22 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 235;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " RELAY 1 OPEN" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_RELAY1_CLOSE_OnPush_23 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 240;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " RELAY 1 CLOSE" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_RELAY2_OPEN_OnPush_24 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 245;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " RELAY 2 OPEN" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_RELAY2_CLOSE_OnPush_25 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 250;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " RELAY 2 CLOSE" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_SAC_OFF_OnPush_26 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 255;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " SAC OFF" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_SAC_CEC_OnPush_27 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 260;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " SAC CEC" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_SAC_ARC_OnPush_28 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 265;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " SAC ARC" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_ARC_SWITCH_DEC_OnChange_29 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 270;
        TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " SWITCH " + Functions.ItoA (  (int) ( TX_ARC_SWITCH_DEC  .UshortValue ) ) + " ARC" + "\u000D\u000A"  ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object TX_NAME_OnChange_30 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        
        __context__.SourceCodeLine = 282;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( Functions.Length( TX_NAME ) > 0 ))  ) ) 
            { 
            __context__.SourceCodeLine = 284;
            TO_DEVICE  .UpdateValue ( "S TX " + Functions.ItoA (  (int) ( TX_ID  .Value ) ) + " NAME " + TX_NAME + "\u000D\u000A"  ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

object FROM_DEVICE_OnChange_31 ( Object __EventInfo__ )

    { 
    Crestron.Logos.SplusObjects.SignalEventArgs __SignalEventArg__ = (Crestron.Logos.SplusObjects.SignalEventArgs)__EventInfo__;
    try
    {
        SplusExecutionContext __context__ = SplusThreadStartCode(__SignalEventArg__);
        CrestronString STR;
        STR  = new CrestronString( Crestron.Logos.SplusObjects.CrestronStringEncoding.eEncodingASCII, 256, this );
        
        ushort INDEX = 0;
        
        
        __context__.SourceCodeLine = 292;
        INDEX = (ushort) ( Functions.Find( "\u000D\u000A" , FROM_DEVICE ) ) ; 
        __context__.SourceCodeLine = 293;
        while ( Functions.TestForTrue  ( ( Functions.BoolToInt ( INDEX > 0 ))  ) ) 
            { 
            __context__.SourceCodeLine = 294;
            STR  .UpdateValue ( Functions.Remove ( "\u000D\u000A" , FROM_DEVICE , INDEX)  ) ; 
            __context__.SourceCodeLine = 296;
            if ( Functions.TestForTrue  ( ( DEBUGMODE  .Value)  ) ) 
                {
                __context__.SourceCodeLine = 296;
                Print( "[From_Device]str = {0}\r\n", STR ) ; 
                }
            
            __context__.SourceCodeLine = 297;
            Functions.ClearBuffer ( STR ) ; 
            __context__.SourceCodeLine = 298;
            INDEX = (ushort) ( Functions.Find( "\u000D\u000A" , FROM_DEVICE ) ) ; 
            __context__.SourceCodeLine = 293;
            } 
        
        __context__.SourceCodeLine = 302;
        if ( Functions.TestForTrue  ( ( Functions.BoolToInt ( Functions.Length( FROM_DEVICE ) > 0 ))  ) ) 
            { 
            __context__.SourceCodeLine = 304;
            Functions.ClearBuffer ( FROM_DEVICE ) ; 
            } 
        
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler( __SignalEventArg__ ); }
    return this;
    
}

public override object FunctionMain (  object __obj__ ) 
    { 
    try
    {
        SplusExecutionContext __context__ = SplusFunctionMainStartCode();
        
        __context__.SourceCodeLine = 311;
        WaitForInitializationComplete ( ) ; 
        
        
    }
    catch(Exception e) { ObjectCatchHandler(e); }
    finally { ObjectFinallyHandler(); }
    return __obj__;
    }
    

public override void LogosSplusInitialize()
{
    SocketInfo __socketinfo__ = new SocketInfo( 1, this );
    InitialParametersClass.ResolveHostName = __socketinfo__.ResolveHostName;
    _SplusNVRAM = new SplusNVRAM( this );
    
    GET_TX_STATUS = new Crestron.Logos.SplusObjects.DigitalInput( GET_TX_STATUS__DigitalInput__, this );
    m_DigitalInputList.Add( GET_TX_STATUS__DigitalInput__, GET_TX_STATUS );
    
    TX_REBOOT = new Crestron.Logos.SplusObjects.DigitalInput( TX_REBOOT__DigitalInput__, this );
    m_DigitalInputList.Add( TX_REBOOT__DigitalInput__, TX_REBOOT );
    
    TX_LED_ON = new Crestron.Logos.SplusObjects.DigitalInput( TX_LED_ON__DigitalInput__, this );
    m_DigitalInputList.Add( TX_LED_ON__DigitalInput__, TX_LED_ON );
    
    TX_LED_OFF = new Crestron.Logos.SplusObjects.DigitalInput( TX_LED_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( TX_LED_OFF__DigitalInput__, TX_LED_OFF );
    
    TX_PREVIEW_ON = new Crestron.Logos.SplusObjects.DigitalInput( TX_PREVIEW_ON__DigitalInput__, this );
    m_DigitalInputList.Add( TX_PREVIEW_ON__DigitalInput__, TX_PREVIEW_ON );
    
    TX_SIGNAL_MUTE_ON = new Crestron.Logos.SplusObjects.DigitalInput( TX_SIGNAL_MUTE_ON__DigitalInput__, this );
    m_DigitalInputList.Add( TX_SIGNAL_MUTE_ON__DigitalInput__, TX_SIGNAL_MUTE_ON );
    
    TX_SIGNAL_MUTE_OFF = new Crestron.Logos.SplusObjects.DigitalInput( TX_SIGNAL_MUTE_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( TX_SIGNAL_MUTE_OFF__DigitalInput__, TX_SIGNAL_MUTE_OFF );
    
    TX_AUDIO_INPUT_HDMI = new Crestron.Logos.SplusObjects.DigitalInput( TX_AUDIO_INPUT_HDMI__DigitalInput__, this );
    m_DigitalInputList.Add( TX_AUDIO_INPUT_HDMI__DigitalInput__, TX_AUDIO_INPUT_HDMI );
    
    TX_AUDIO_INPUT_ANA = new Crestron.Logos.SplusObjects.DigitalInput( TX_AUDIO_INPUT_ANA__DigitalInput__, this );
    m_DigitalInputList.Add( TX_AUDIO_INPUT_ANA__DigitalInput__, TX_AUDIO_INPUT_ANA );
    
    TX_IR_VOL_5V = new Crestron.Logos.SplusObjects.DigitalInput( TX_IR_VOL_5V__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IR_VOL_5V__DigitalInput__, TX_IR_VOL_5V );
    
    TX_IR_VOL_12V = new Crestron.Logos.SplusObjects.DigitalInput( TX_IR_VOL_12V__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IR_VOL_12V__DigitalInput__, TX_IR_VOL_12V );
    
    TX_IO_VOL_5V = new Crestron.Logos.SplusObjects.DigitalInput( TX_IO_VOL_5V__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IO_VOL_5V__DigitalInput__, TX_IO_VOL_5V );
    
    TX_IO_VOL_12V = new Crestron.Logos.SplusObjects.DigitalInput( TX_IO_VOL_12V__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IO_VOL_12V__DigitalInput__, TX_IO_VOL_12V );
    
    TX_IO1_DIR_IN = new Crestron.Logos.SplusObjects.DigitalInput( TX_IO1_DIR_IN__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IO1_DIR_IN__DigitalInput__, TX_IO1_DIR_IN );
    
    TX_IO1_DIR_OUT = new Crestron.Logos.SplusObjects.DigitalInput( TX_IO1_DIR_OUT__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IO1_DIR_OUT__DigitalInput__, TX_IO1_DIR_OUT );
    
    TX_IO2_DIR_IN = new Crestron.Logos.SplusObjects.DigitalInput( TX_IO2_DIR_IN__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IO2_DIR_IN__DigitalInput__, TX_IO2_DIR_IN );
    
    TX_IO2_DIR_OUT = new Crestron.Logos.SplusObjects.DigitalInput( TX_IO2_DIR_OUT__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IO2_DIR_OUT__DigitalInput__, TX_IO2_DIR_OUT );
    
    TX_IO1_OUT_LOW = new Crestron.Logos.SplusObjects.DigitalInput( TX_IO1_OUT_LOW__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IO1_OUT_LOW__DigitalInput__, TX_IO1_OUT_LOW );
    
    TX_IO1_OUT_HIGH = new Crestron.Logos.SplusObjects.DigitalInput( TX_IO1_OUT_HIGH__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IO1_OUT_HIGH__DigitalInput__, TX_IO1_OUT_HIGH );
    
    TX_IO2_OUT_LOW = new Crestron.Logos.SplusObjects.DigitalInput( TX_IO2_OUT_LOW__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IO2_OUT_LOW__DigitalInput__, TX_IO2_OUT_LOW );
    
    TX_IO2_OUT_HIGH = new Crestron.Logos.SplusObjects.DigitalInput( TX_IO2_OUT_HIGH__DigitalInput__, this );
    m_DigitalInputList.Add( TX_IO2_OUT_HIGH__DigitalInput__, TX_IO2_OUT_HIGH );
    
    TX_RELAY1_OPEN = new Crestron.Logos.SplusObjects.DigitalInput( TX_RELAY1_OPEN__DigitalInput__, this );
    m_DigitalInputList.Add( TX_RELAY1_OPEN__DigitalInput__, TX_RELAY1_OPEN );
    
    TX_RELAY1_CLOSE = new Crestron.Logos.SplusObjects.DigitalInput( TX_RELAY1_CLOSE__DigitalInput__, this );
    m_DigitalInputList.Add( TX_RELAY1_CLOSE__DigitalInput__, TX_RELAY1_CLOSE );
    
    TX_RELAY2_OPEN = new Crestron.Logos.SplusObjects.DigitalInput( TX_RELAY2_OPEN__DigitalInput__, this );
    m_DigitalInputList.Add( TX_RELAY2_OPEN__DigitalInput__, TX_RELAY2_OPEN );
    
    TX_RELAY2_CLOSE = new Crestron.Logos.SplusObjects.DigitalInput( TX_RELAY2_CLOSE__DigitalInput__, this );
    m_DigitalInputList.Add( TX_RELAY2_CLOSE__DigitalInput__, TX_RELAY2_CLOSE );
    
    TX_SAC_OFF = new Crestron.Logos.SplusObjects.DigitalInput( TX_SAC_OFF__DigitalInput__, this );
    m_DigitalInputList.Add( TX_SAC_OFF__DigitalInput__, TX_SAC_OFF );
    
    TX_SAC_CEC = new Crestron.Logos.SplusObjects.DigitalInput( TX_SAC_CEC__DigitalInput__, this );
    m_DigitalInputList.Add( TX_SAC_CEC__DigitalInput__, TX_SAC_CEC );
    
    TX_SAC_ARC = new Crestron.Logos.SplusObjects.DigitalInput( TX_SAC_ARC__DigitalInput__, this );
    m_DigitalInputList.Add( TX_SAC_ARC__DigitalInput__, TX_SAC_ARC );
    
    TX_PREVIEW_PHOTO = new Crestron.Logos.SplusObjects.AnalogInput( TX_PREVIEW_PHOTO__AnalogSerialInput__, this );
    m_AnalogInputList.Add( TX_PREVIEW_PHOTO__AnalogSerialInput__, TX_PREVIEW_PHOTO );
    
    TX_ARC_SWITCH_DEC = new Crestron.Logos.SplusObjects.AnalogInput( TX_ARC_SWITCH_DEC__AnalogSerialInput__, this );
    m_AnalogInputList.Add( TX_ARC_SWITCH_DEC__AnalogSerialInput__, TX_ARC_SWITCH_DEC );
    
    TX_NAME = new Crestron.Logos.SplusObjects.StringInput( TX_NAME__AnalogSerialInput__, 16, this );
    m_StringInputList.Add( TX_NAME__AnalogSerialInput__, TX_NAME );
    
    TO_DEVICE = new Crestron.Logos.SplusObjects.StringOutput( TO_DEVICE__AnalogSerialOutput__, this );
    m_StringOutputList.Add( TO_DEVICE__AnalogSerialOutput__, TO_DEVICE );
    
    FROM_DEVICE = new Crestron.Logos.SplusObjects.BufferInput( FROM_DEVICE__AnalogSerialInput__, 4096, this );
    m_StringInputList.Add( FROM_DEVICE__AnalogSerialInput__, FROM_DEVICE );
    
    DEBUGMODE = new UShortParameter( DEBUGMODE__Parameter__, this );
    m_ParameterList.Add( DEBUGMODE__Parameter__, DEBUGMODE );
    
    TX_ID = new UShortParameter( TX_ID__Parameter__, this );
    m_ParameterList.Add( TX_ID__Parameter__, TX_ID );
    
    
    GET_TX_STATUS.OnDigitalPush.Add( new InputChangeHandlerWrapper( GET_TX_STATUS_OnPush_0, false ) );
    TX_REBOOT.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_REBOOT_OnPush_1, false ) );
    TX_LED_ON.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_LED_ON_OnPush_2, false ) );
    TX_LED_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_LED_OFF_OnPush_3, false ) );
    TX_PREVIEW_ON.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_PREVIEW_ON_OnPush_4, false ) );
    TX_PREVIEW_PHOTO.OnAnalogChange.Add( new InputChangeHandlerWrapper( TX_PREVIEW_PHOTO_OnChange_5, false ) );
    TX_SIGNAL_MUTE_ON.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_SIGNAL_MUTE_ON_OnPush_6, false ) );
    TX_SIGNAL_MUTE_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_SIGNAL_MUTE_OFF_OnPush_7, false ) );
    TX_AUDIO_INPUT_HDMI.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_AUDIO_INPUT_HDMI_OnPush_8, false ) );
    TX_AUDIO_INPUT_ANA.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_AUDIO_INPUT_ANA_OnPush_9, false ) );
    TX_IR_VOL_5V.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IR_VOL_5V_OnPush_10, false ) );
    TX_IR_VOL_12V.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IR_VOL_12V_OnPush_11, false ) );
    TX_IO_VOL_5V.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IO_VOL_5V_OnPush_12, false ) );
    TX_IO_VOL_12V.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IO_VOL_12V_OnPush_13, false ) );
    TX_IO1_DIR_IN.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IO1_DIR_IN_OnPush_14, false ) );
    TX_IO1_DIR_OUT.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IO1_DIR_OUT_OnPush_15, false ) );
    TX_IO2_DIR_IN.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IO2_DIR_IN_OnPush_16, false ) );
    TX_IO2_DIR_OUT.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IO2_DIR_OUT_OnPush_17, false ) );
    TX_IO1_OUT_LOW.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IO1_OUT_LOW_OnPush_18, false ) );
    TX_IO1_OUT_HIGH.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IO1_OUT_HIGH_OnPush_19, false ) );
    TX_IO2_OUT_LOW.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IO2_OUT_LOW_OnPush_20, false ) );
    TX_IO2_OUT_HIGH.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_IO2_OUT_HIGH_OnPush_21, false ) );
    TX_RELAY1_OPEN.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_RELAY1_OPEN_OnPush_22, false ) );
    TX_RELAY1_CLOSE.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_RELAY1_CLOSE_OnPush_23, false ) );
    TX_RELAY2_OPEN.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_RELAY2_OPEN_OnPush_24, false ) );
    TX_RELAY2_CLOSE.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_RELAY2_CLOSE_OnPush_25, false ) );
    TX_SAC_OFF.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_SAC_OFF_OnPush_26, false ) );
    TX_SAC_CEC.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_SAC_CEC_OnPush_27, false ) );
    TX_SAC_ARC.OnDigitalPush.Add( new InputChangeHandlerWrapper( TX_SAC_ARC_OnPush_28, false ) );
    TX_ARC_SWITCH_DEC.OnAnalogChange.Add( new InputChangeHandlerWrapper( TX_ARC_SWITCH_DEC_OnChange_29, false ) );
    TX_NAME.OnSerialChange.Add( new InputChangeHandlerWrapper( TX_NAME_OnChange_30, false ) );
    FROM_DEVICE.OnSerialChange.Add( new InputChangeHandlerWrapper( FROM_DEVICE_OnChange_31, true ) );
    
    _SplusNVRAM.PopulateCustomAttributeList( true );
    
    NVRAM = _SplusNVRAM;
    
}

public override void LogosSimplSharpInitialize()
{
    
    
}

public UserModuleClass_TRANSMITTER_CN_AV_V1 ( string InstanceName, string ReferenceID, Crestron.Logos.SplusObjects.CrestronStringEncoding nEncodingType ) : base( InstanceName, ReferenceID, nEncodingType ) {}




const uint GET_TX_STATUS__DigitalInput__ = 0;
const uint TX_REBOOT__DigitalInput__ = 1;
const uint TX_LED_ON__DigitalInput__ = 2;
const uint TX_LED_OFF__DigitalInput__ = 3;
const uint TX_PREVIEW_ON__DigitalInput__ = 4;
const uint TX_SIGNAL_MUTE_ON__DigitalInput__ = 5;
const uint TX_SIGNAL_MUTE_OFF__DigitalInput__ = 6;
const uint TX_AUDIO_INPUT_HDMI__DigitalInput__ = 7;
const uint TX_AUDIO_INPUT_ANA__DigitalInput__ = 8;
const uint TX_IR_VOL_5V__DigitalInput__ = 9;
const uint TX_IR_VOL_12V__DigitalInput__ = 10;
const uint TX_IO_VOL_5V__DigitalInput__ = 11;
const uint TX_IO_VOL_12V__DigitalInput__ = 12;
const uint TX_IO1_DIR_IN__DigitalInput__ = 13;
const uint TX_IO1_DIR_OUT__DigitalInput__ = 14;
const uint TX_IO2_DIR_IN__DigitalInput__ = 15;
const uint TX_IO2_DIR_OUT__DigitalInput__ = 16;
const uint TX_IO1_OUT_LOW__DigitalInput__ = 17;
const uint TX_IO1_OUT_HIGH__DigitalInput__ = 18;
const uint TX_IO2_OUT_LOW__DigitalInput__ = 19;
const uint TX_IO2_OUT_HIGH__DigitalInput__ = 20;
const uint TX_RELAY1_OPEN__DigitalInput__ = 21;
const uint TX_RELAY1_CLOSE__DigitalInput__ = 22;
const uint TX_RELAY2_OPEN__DigitalInput__ = 23;
const uint TX_RELAY2_CLOSE__DigitalInput__ = 24;
const uint TX_SAC_OFF__DigitalInput__ = 25;
const uint TX_SAC_CEC__DigitalInput__ = 26;
const uint TX_SAC_ARC__DigitalInput__ = 27;
const uint TX_PREVIEW_PHOTO__AnalogSerialInput__ = 0;
const uint TX_ARC_SWITCH_DEC__AnalogSerialInput__ = 1;
const uint TX_NAME__AnalogSerialInput__ = 2;
const uint FROM_DEVICE__AnalogSerialInput__ = 3;
const uint TO_DEVICE__AnalogSerialOutput__ = 0;
const uint DEBUGMODE__Parameter__ = 10;
const uint TX_ID__Parameter__ = 11;

[SplusStructAttribute(-1, true, false)]
public class SplusNVRAM : SplusStructureBase
{

    public SplusNVRAM( SplusObject __caller__ ) : base( __caller__ ) {}
    
    
}

SplusNVRAM _SplusNVRAM = null;

public class __CEvent__ : CEvent
{
    public __CEvent__() {}
    public void Close() { base.Close(); }
    public int Reset() { return base.Reset() ? 1 : 0; }
    public int Set() { return base.Set() ? 1 : 0; }
    public int Wait( int timeOutInMs ) { return base.Wait( timeOutInMs ) ? 1 : 0; }
}
public class __CMutex__ : CMutex
{
    public __CMutex__() {}
    public void Close() { base.Close(); }
    public void ReleaseMutex() { base.ReleaseMutex(); }
    public int WaitForMutex() { return base.WaitForMutex() ? 1 : 0; }
}
 public int IsNull( object obj ){ return (obj == null) ? 1 : 0; }
}


}
