PROGRAM_NAME='Vanco_Demo'

(***********************************************************)
(*          DEVICE NUMBER DEFINITIONS GO BELOW             *)
(***********************************************************)
define_device

dvTp = 10001:1:1

vdvModule_EVSW1061 = 33001:1:1
vdvModule_EVSW21MV = 33002:1:1
vdvModule_EVSW1042 = 33003:1:1
vdvModule_EVSP14VW = 33004:1:1

// n.b. Some controllers have limited ports (:middle digit:).
// Re-number to test as appropriate.
dvVanco_SERIAL_9600   = 5001:1:1
dvVanco_SERIAL_19200  = 5001:2:1
dvVanco_SERIAL_115200 = 5001:3:1

// Vanco connection via IP...
dvVanco_IP = 0:4:0

(***********************************************************)
(*               CONSTANT DEFINITIONS GO BELOW             *)
(***********************************************************)
define_constant

// Controller

SELECT_EVSW1061 = 1;
SELECT_EVSP14VW = 2;
SELECT_EVSW1042 = 3;
SELECT_EVSW21MV = 4;

(***********************************************************)
(*               VARIABLE DEFINITIONS GO BELOW             *)
(***********************************************************)
define_variable

// Dummy empty IP address to indicate a serial connection
char EVSP14VW_USE_SERIAL[15] = '';
char EVSP14VW_DEFAULT_IP[15] = '192.168.0.100';
char EVSP14VW_TEST_IP[15]    = '172.16.112.42';  
dev CurrentDevice;

(***********************************************************)
(*                MODULE DEFINITIONS GO BELOW              *)
(***********************************************************)
define_module 'Vanco_EVSW1061' Vanco_EVSW1061( vdvModule_EVSW1061, dvVanco_SERIAL_9600);
define_module 'Vanco_EVSW21MV' Vanco_EVSW21MV( vdvModule_EVSW21MV, dvVanco_SERIAL_115200);
define_module 'Vanco_EVSW1042' Vanco_EVSW1042( vdvModule_EVSW1042, dvVanco_SERIAL_19200);

define_module 'Vanco_EVSP14VW' Vanco_EVSP14VW( vdvModule_EVSP14VW, dvVanco_SERIAL_115200, EVSP14VW_USE_SERIAL);
//define_module 'Vanco_EVSP14VW' Vanco_EVSP14VW( vdvModule_EVSP14VW, dvVanco_IP, EVSP14VW_TEST_IP);

(***********************************************************)
(*                THE EVENTS GO BELOW                      *)
(***********************************************************)
define_event

button_event[dvtP, 0]
{
    push:
    {
	integer lst 
	lst = button.input.channel;

	[dvtP, 1] = 0
	[dvtP, 2] = 0
	[dvtP, 3] = 0
	[dvtP, 4] = 0
	[dvtP, button.input.channel] = 1

	switch(lst)
	{
	    case SELECT_EVSW1061:
	    {
		CurrentDevice = vdvModule_EVSW1061;
	    }
	    case SELECT_EVSP14VW:
	    {
		CurrentDevice = vdvModule_EVSP14VW;
	    }
	    case SELECT_EVSW1042:
	    {
		CurrentDevice = vdvModule_EVSW1042;
	    }
	    case SELECT_EVSW21MV:
	    {
		CurrentDevice = vdvModule_EVSW21MV;
	    }
	    default:
	    {
		CurrentDevice = vdvModule_EVSW1061;
	    }
	}
    }
}

data_event[dvtP]
{
    command:
    {
	send_command CurrentDevice, data.text;
    }
}

(***********************************************************)
(*            THE ACTUAL PROGRAM GOES BELOW                *)
(***********************************************************)
define_program
